float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4x4 World : WORLD;

float4 Kolor : COLOR = float4(1,1,0,1);
bool MapujKolorWerteksu = false;

bool OswietleniePerPixel = true; 

//zrodla swiatla
float4 Ce : COLOR = float4(0,0,0,1);
float4 Ca : COLOR = float4(0.1,0.1,0.1,1);
float4 Cd : COLOR = float4(0.5,0.5,0.5,1);
float4 Cs : COLOR = float4(1,1,1,1);

//material
float4 Wa = float4(1,1,1,1);
float4 Wd = float4(1,1,1,1);
float4 Ws = float4(1,1,1,1);
float ns = 10;

float3 PozycjaZrodlaSwiatla = float3(1,1,1);
float3 PolozenieKamery : CAMERAPOSITION = float3(0,0,1);

struct Dane_PozycjaKolor
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
};

struct Dane_PozycjaNormalna
{
	float4 Polozenie : POSITION0;
	float4 Normalna : NORMAL0;
};

struct Dane_PozycjaKolorNR
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
	float3 N : TEXCOORD1;
	float3 R : TEXCOORD2;
};

bool TlumienieOswietlenia = true;
//staly,liniowy,kwadratowy (C,L,Q)
//float3 WspolczynnikTlumienia = float3(1,0,0); C=1,L=Q=0 - bez tlumienia
float3 WspolczynnikTlumienia = float3(0,0,0.5); 

float tlumienie(float odleglosc)
{
	if(!TlumienieOswietlenia) return 1;
	else
	{
		return 1.0/(WspolczynnikTlumienia[0]+
		            WspolczynnikTlumienia[1]*odleglosc+
					WspolczynnikTlumienia[2]*odleglosc*odleglosc);
	}
}

float4 ObliczKolor(float4 kolor :COLOR,float3 N,float3 R)
{
	float3 odleglosc=PozycjaZrodlaSwiatla-R;
	float3 L=normalize(odleglosc);
	float dotLN=saturate(dot(L,N));	
	float3 O = 2*dotLN*N-L;
	float3 V = normalize(PolozenieKamery-R);
	float dotOVn = saturate(pow(saturate(dot(O,V)),ns));

	//do poprawy
	float4 _Ce=Ce;
	float4 _Ca=Ca;
	float4 _Cd=Cd;
	if(MapujKolorWerteksu)
	{
		_Ce=kolor;
		_Ca=kolor;
		_Cd=kolor;
	}

	float4 Kolor=saturate(_Ce);
	Kolor+=saturate(Wa*_Ca);
	Kolor+=saturate(Wd*_Cd*dotLN);
	Kolor+=saturate(Ws*Cs*dotOVn);
	Kolor=saturate(tlumienie(length(odleglosc))*Kolor);
	return Kolor;
}

//Dane_PozycjaKolor VS(float4 Polozenie : POSITION0)
Dane_PozycjaKolorNR VS(Dane_PozycjaNormalna input)
{
	/*
	//kolorowanie wg. normalnych
	Dane_PozycjaKolorNR output;
	output.Polozenie=mul(input.Polozenie,WorldViewProjection);
	output.Kolor.rgb=abs(input.Normalna);
	output.Kolor.a=1;
	output.N=float4(0,0,0,0);
	output.R=float4(0,0,0,0);
	return output;
	*/

	float3 R=mul(input.Polozenie,World).xyz;
	float3 N=mul(input.Normalna,World); //nie do konca poprawne!!!

    Dane_PozycjaKolorNR output;
	output.Polozenie=mul(input.Polozenie,WorldViewProjection);
	output.Kolor=(!OswietleniePerPixel)?ObliczKolor(Kolor,N,R):Kolor;
	output.N=N;
	output.R=R;
	return output;
}

//float4 PS(Dane_PozycjaKolor input) : COLOR0
float4 PS(Dane_PozycjaKolorNR input) : COLOR0
{
	//return input.Kolor;
	return OswietleniePerPixel?ObliczKolor(input.Kolor,input.N,input.R):input.Kolor;
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}